#|___________________________________________________________________ 
 | 
 | ViSta - The Visual Statistics System
 | Copyright (c) 1991-2000 by Forrest W. Young
 | For further information contact the author 
 |
 | MAKER.LSP
 | This is the file contains code used to construct and enter the
 | developers world. In particular, this files makes ViSta 
 |___________________________________________________________________ 
 |
 | STARTER STARTUP ACTION
 | ViSta   ReStart restart vista after xlisp.wks is created
 | ViSta   Install Install ViSta after net download
 | ViSta   None    no-op. default off value
 | Excel   [name]  load startup/excel/name.lsp for excel connection
 | Access  [name]  load startup/access/name.lsp for access connection
 |___________________________________________________________________
 |#

(setf *edit-lisp-files* nil) ;place in load lsp files mode

(unless (boundp *make-log*)
        (setf *make-log* nil))

(when *make-log*
      (setf *log-verbose* t)
      (setf *file-verbose* t)
      (setf *load-verbose* t))
(setf *please-wait* nil)
(setf *please-waiter* nil)
(setf *make-distribution* nil)

(load "autoload\\_autoidx.lsp")
(load "autoload\\bayes.fsl")
(load "autoload\\glim.fsl")
(load "autoload\\maximize.fsl")
(load "autoload\\nonlin.fsl")
(load "autoload\\oneway.fsl")
(load "autoload\\stepper.fsl")

;(format t (string-upcase "~%; Genesys Creating Initial Conditions~2%"))

(setf *separator* #+macintosh ":" #+msdos "\\" #+X11 "/") 
(setf separator *separator*)
(setf *run-number* -10);initialization value
(setf *log-number* 0)
(setf *build-number* nil)

(unless (boundp *dribble-on*) (setf *dribble-on* nil))

(load (format nil "maketime~adefun0" separator))

;(listeners :micro t)

(let* ((curdir (get-working-directory))
       (libdir (msw-get-profile-string "ViSta" "LibDir" 
                        (strcat curdir "wxls32.ini")))
       (ini (strcat libdir "\\wxls32.ini"))
       (restart? (msw-get-profile-string "ViSta" "StartUp" ini))
       )
  (when (equal "restart" (string-downcase restart?))
        (exit)))

(setf *active-container*
      (send container-proto :new 2 :show nil))

(send *active-container* :getobjects nil)
(setf *active-container* nil)

(please-wait "Make ViSta: Loading XLisp" :title "Make ViSta" :pause 30)

;(setf *dribble-on* nil)
(setf *statinit-maker-error-flag* t) 
(setf *vista-start-case* 0);maker started
(failsafe-load "prefs\\" "version.lsp")

(when *make-log* (double-dribble (format nil "wks~a.log" (1+ *log-number*))))

;(setf *NUM-LISTENER-LINES* 6)

(xls-copyright) 
(xls-mod-copyright) 
(vista-copyright *run-number* 4 )

(when *make-log*
       (format t "~%~a" *xls-copyright*))
(format t "~3%~a" *xls-mod-copyright*)


;paths are defined within the let so that the workspace is path-clean

(let* ((*default-path* (format nil "~a~a" (get-working-directory) "\\"))
       (*default-path-default* *default-path*)
       (*system-path* *default-path*)
       (*startup-dir* (get-working-directory))
       (*prefs-dir-name* (format nil "~a~a" *default-path* "prefs"))
       (*prefs-path* (format nil "~a~a" *default-path* "prefs\\"))
       (*source-path* (format nil "~a~a" *default-path* "source\\"))
       (*devel-path* (format nil "~a~a" *source-path* "devloper\\"))
       (*distrib-path* (format nil "~a~a" *source-path* "distrib\\"))
      )

#|
 | INITIALIZING
 |#
  
  (please-wait "Make ViSta: Initial Paths and Functions" :title "Make ViSta" :pause 30)
 ; (xls-mod-copyright) 
 ; (format t "~%~a" *xls-mod-copyright*)
  (format t (string-upcase "~%; Initialize ViSta.~%"))
  (format t "~%; these paths defined only during maketime~%")
  (format t "; *default-path* ~a~%" *default-path*)
  (format t "; *prefs-path*   ~a~%" *prefs-path*)
  (format t "; *source-path*  ~a~%" *source-path*)
  (format t "; *devel-path*   ~a~%" *devel-path*)

  (setf *make-time* t)
  (setf *vista-startup* t)
  (setf *genesys* nil)
  (setf *verbose* nil)
  (setf *version-string* nil)
  (format t (string-upcase "~%; Define Initial Functions and Initialize Variables~2%"))
  (setf *separator* #+macintosh ":" #+msdos "\\" #+X11 "/") 
  (setf separator *separator*)
  (setf *run-number* -10);initialization value
  (setf *log-number* 0)
  (setf *build-number* nil)

  (load (format nil "maketime~adefvar" separator))
  (load (format nil "maketime~adefun1" separator))
  (load (format nil "maketime~adefun2" separator))
  (load (format nil "maketime~adefun3" separator))
  (load (format nil "maketime~adefpref0" separator))
  (load (format nil "maketime~adefpref1" separator))
  (load (format nil  "runtime~apaths000" separator));fwy added 12292000
  (load (format nil "maketime~apaths001" separator));fwy added 12272000replace runtime\\paths
  (load (format nil "maketime~averbose" separator)) ;;fwy added 10172001
  (load (format nil "maketime~adeveltools" separator));;fwy added 10172001
  (load (format nil "maketime~astartman" separator));;fwy added 05282002
  ;(load "runtime\\paths000"); fwy added 12292000
  ;(load "maketime\\paths001");fwy added 12272000 to replace runtime\\paths
  ;(load "maketime\\verbose");fwy added 10172001
  (get-ini-paths :dir (get-working-directory))

  (verbose t)
  (setf *release-date* (first (date-time)))
  (setf *short-release-date* (fifth (date-time)))
  (setf *features* (combine ':containers *features*)) 
  (failsafe-load *prefs-path* "initial.lsp")
  (failsafe-load *prefs-path* "prefload.lsp")
 ; (when *visible-startup* (maxmainwindow))
  (make-vista-id-number)
  (make-vista-copyright)
  (defun copyright ()
    (format t "~%~a" *vista-copyright*))
  (format t "; expanding memory~%")
  ;(expand 200)
  (setf *load-verbose* t)
  (load "runtime\\dialogs")
  ;(load "runtime\\paths000");fwy added 12292000
  ;(load "maketime\\paths001");fwy added 12272000 to replace runtime\\paths
  (load (strcat "autoload" separator "glim"))
  (load (strcat "maketime" separator "fastload"))

  
#|
 | LOAD FILES
 |#



  (please-wait "Make ViSta: Loading Files - Source"
               :title "Make ViSta" :pause 30)
  

  (format t "~%; Loading Files~2%")
  (setf *compiled-file-listing?* t)
  (setf *load-verbose* *compiled-file-listing?*)  
  (unless *load-verbose* (format t "; loading initial LSP files"))
  (load "source//vinstall.lsp")
  (load "maketime//fastload.lsp")
 

  (load "source//devloper//developer.lsp")
  (unless *load-verbose* (format t "; loading FSL files"))

  (please-wait "Make ViSta [maker.lsp] : Loading Files - Byte-Code"
               :title "Make ViSta")
  ;(pause 40)
  ;(format t "; compiling changed vista sources, if any")
  ;(compile-changed-vista-sources)

  (format t "; loading standard program core files")

  (setf *compiling* nil)
  (please-wait "Make ViSta: Loading Files - Byte-Code"
               :title "Make ViSta")
  (load-program-files *prefs-dir-name*)
  (please-wait "Make ViSta: Loading Files - Special"
               :title "Make ViSta")
  (format t "~%; loading special files~%")
  (load (strcat *source-dir-name* "install2"))
  (load (strcat *default-path* "update\\phase0.lsp") :if-does-not-exist nil)
 

;(setf *make-distribution* t)



  (when *devel-version*
        (format t "; loading developer   files~%")
        (let ((files (directory (strcat *devel-path* "*.*"))))
          (when files
                (mapcar #'(lambda (developer-file) 
                            (load developer-file))
                        files)))
        (format t "; loading distributor files~%")
        (load (strcat *distrib-path* "distributor") :if-does-not-exist nil))


 ; (setf *load-verbose* t)
 ; (setf *file-verbose* t)


#|
 | CONFIGURING
 |#


  (please-wait "Make ViSta: Configuring WorkSpace"
               :title "Make ViSta" :pause 30)
  (format t "; configuring fonts and directories~%")
  (setf *change-fonts* nil)
  (setf *change-directories* nil)
  (msw-write-profile-string "XLisp" "HideMainFrame" "yes" "wxls32.ini") 
  (unless *genesys* (format t "; hid mainframe window for future runs~%"))
  (msw-write-profile-string "ViSta" "ViStaOp" "no" "wxls32.ini")
  (format t "; configured excel and access~%")
  ;number of runs (logs) and builds since January 13, 2000
  (setf *log-number* (1+ *log-number*))
  (setf *build-number* (1+ *build-number*))
  (make-vista-id-number)
#|
 | EXITING
 |#

  (setf *tracelimit* 3)
  (setf *visible-startup* nil)
  (setf *debug-mode* nil)
  (setf *rebuild-after-compile-needed* nil)
  (setf *build-date* (time-stamp))
  (setf *builder-id* (user-id))
  (setf *vista-id* *vista-id-number*)
  (setf *local-vista-id-number* *vista-id*)
  (setf *load-verbose* t)
  (setf *logo* nil)
  (setf *create-vista* t)
  (setf *vista-exists* nil)
  (setf *hide-vista* nil)
  (setf *hide-logo* nil)
  (vista-copyright)
  (terpri)
  (format t "~2%VISTA WORKSPACE ~A BUILT. SAVING WORKSPACE~%" *vista-id-number*)
  (print-closing-workspace-id-info "Distribution" "unlocalized" "vista-installer.wks")
  (when *make-distribution* (load (strcat *distrib-path* "now-what")))
  ;(project-stats-dialog)
  ;(verbose t)
  (now-what?)
  (setf *vista-start-case* nil)
  (format t "; exiting from maker")
  (top-level);sometimes one doesnt work
  (top-level)
  (top-level)
  )
